using UnityEngine;
using System.Collections;

public class meteor : MonoBehaviour {
	
	public Vector3 		targetTransform;
	public string 		styleMeteor;
	
	public GameObject explosionPrfab01;
	public GameObject explosionPrfab02;
	public GameObject explosionPrfab03;
	
	private GameObject explosion;
	private bool once = true;
	
	// Use this for initialization
	void Start () {
		
		styleMeteor = GameObject.Find("Camera").GetComponent<planete>().weaponUse;
		switch(styleMeteor)
		{
			case "METEOR01": explosion = explosionPrfab01; break;
			case "METEOR02": explosion = explosionPrfab02; break;
			case "METEOR03": explosion = explosionPrfab03; break;
		}		
	}
	
	// Update is called once per frame
	void Update () {
		
		transform.LookAt(targetTransform);
		transform.Translate( Vector3.forward * Time.deltaTime * 50.0f);	
		
		if(Vector3.Distance( transform.position, targetTransform) < 0.4f && once){
			once = false;
			GameObject.Find("Camera").GetComponent<planete>().explosionImpact(transform.position, styleMeteor);
			Instantiate( explosion, targetTransform, Quaternion.LookRotation(targetTransform));
			Destroy(gameObject);
		}
	}
	
}
